--[[
**************************************************************************
*     Serveur IOCP pour LockOn 1.12a,1.12b                               *
*     Par Lecreole  -  http://charles.contact.free.fr                    *
*     Version 1.1.5  du   13/05/2008                                             *
**************************************************************************
--]]

dofile "lua.lua";
socket = require("socket");

MODULE_SIOC = true; -- Activer le module SIOC
DEBUG_MODE = true; 	-- fichier ..\Lock On\Temp\Export.log

LoiocpServeur =
{
	MAX_SLOTS = 2,                 	-- Nombre maximun de slots clients
 	SOCKET_PORT = 1452,			   	-- Port du serveur LoiocpServeur
 	SOCKET_HOST = "*",	   		   	-- Host du serveur
	DELAI_ACTUALISATION_INFO = 0.1,	-- Temps entre chaque mise  jour des infos (sec.)
 	slotClients = {},			   	-- Liste des slots clients
 	nombreClient = 0,              	-- Nombre de client connects
 	serveurTcp = nil,              	-- Handle du serveur
 	ancieneValeur = {},			   	-- Liste des Valeurs lockon prcdentes
 	specialInfos = {1,1,1,1,1},       -- (1=target|2=lockTarget|3=emitters|4=waypoints)

 	------------------------------------------------------------------------
 	--    Fonction pour la cration du serveur TCP Lockon                 --
 	------------------------------------------------------------------------
	creerIOCPServeur = function(self)
		-- Cration du serveur tcp
 		self.serveurTcp, err  = self.creerServeurTcp(self);
		-- init delai pour la mise  jour de l'info.
		self.actualisationSuivant = 0;
 		if self.serveurTcp then
	 		-- Cration et libration des slots disponibles
	 		for i=1,self.MAX_SLOTS do
	 			self.slotClients[i] = "libre";
	 		end
	 		-- Evnement si la cration du serveur  russi
 			log(string.format("Serveur iocp dmarr port %d (%d slots disponible(s))\n",self.SOCKET_PORT,self.MAX_SLOTS));
		else
	        -- Evnement si la cration du serveur  chou
			log(string.format("Erreur cration serveur : %s.\n",err));
 	    end
 	end,
 	------------------------------------------------------------------------
 	--    Fonction pour crer un serveur Tcp							  --
	------------------------------------------------------------------------
 	creerServeurTcp = function(self)
 		local serveurTcp, err = socket.tcp();
		if serveurTcp==nil then
			return nil, err;
		end

		serveurTcp:setoption( "reuseaddr", true );
		local res, err = serveurTcp:bind( self.SOCKET_HOST, self.SOCKET_PORT );
		if res==nil then
			return nil, err;
		end

		res, err = serveurTcp:listen(10);
		if res==nil then
			return nil, err;
		end
        serveurTcp:settimeout(0);
		return serveurTcp;
	end,
 	------------------------------------------------------------------------
 	--    Fonction en boucle pour accepter les nouveau clients, envoyer   --
	--    et reevoir les messages                                        --
 	------------------------------------------------------------------------
 	demarrerServeurTcp = function(self)
		local temps = LoGetModelTime();
		local actualisation = false;
		if temps >= self.actualisationSuivant then
            actualisation = true;
			self.actualisationSuivant = temps + self.DELAI_ACTUALISATION_INFO;
  		end
 		-- Recherche de nouveau client
		local nouveauClientTcp, err = self.serveurTcp:accept();
		if nouveauClientTcp ~= nil then
		    local slotDisponible = self.rechercheSlot(self);
		    if slotDisponible ~= nil then
				-- Si slot disponible
				-- Ajout du nouveau client
			    self.ajouterNouveauClient(self,nouveauClientTcp,slotDisponible);
			end
		end
        if self.nombreClient > 0 and LoGetPlayerPlaneId() and actualisation then
			-- Parcours la liste des slots clients
			for n,slot in pairs(self.slotClients) do
				if self.slotClients[n] ~= "libre" then
					-- Contrle si le client est toujours connect
				    local ip, err = slot.tcpClient:getsockname();
				    if ip ~= "0.0.0.0" then  -- si client toujour actif
						-- Recheche si message en provenance du client
						slot.initInicio=false;
						local messageRecu, err = slot.tcpClient:receive('*l');
						if messageRecu ~= nil then -- si message reu
							-- log(string.format("Message du client(id:%s) : %s.\n",slot.idClient,messageRecu));
						    -- Vrifie que l'entte du message est correcte
						    local s,l,typeMessage = string.find(messageRecu,"(Arn.%w+)");
						    typeMessage = tostring(typeMessage);
						    ------------------------------------------------------------
						    -- Les types de message accepts :                        --
						    --                                                        --
						    -- Arn.Vivo   : Le serveur  reu "Arn.Vivo": du client   --
						    --              Le serveur rpond "Arn.Vivo"              --
						    -- Arn.Inicio : Le serveur stock les valeurs corespondant --
							--              aux infos que le client souhaite recevoir --
							--				Ex: Arn.Inicio:10:11:                     --
							--														  --
							-- Arn.Resp   : Message pour l'execution des commandes    --
							--              seul deux valeurs sont acceptes:         --
							--				0=[valeur] -> le paramtres valeur(      )--
							-- 				1=[valeur] -> le paramtre commande		  --
							--				Ex:Arn.Resp:0=5000:1=3: ou Arn.Resp:1=145:--
							--              a noter que Arn.Resp:1=0: remets le       --
							--              cache valeur  'nil' aussi aprs chaque   --
							--				commande excut                          --
							------------------------------------------------------------
							if typeMessage == "Arn.Vivo" then
								--------------------------------------------------------
								-- Type = Arn.Vivo:                                   --
								--------------------------------------------------------
								log(string.format("Message du client(id:%s) : %s.\n",slot.idClient,messageRecu));
								-- Renvoi Arn.Vivo
								slot.tcpClient:send("Arn.Vivo:");

							elseif typeMessage == "Arn.Resp" then
							    --------------------------------------------------------
								-- Type = Arn.Resp:                                   --
								--------------------------------------------------------
		      					-- Controle si le message est valide
							    local s,l,message = string.find(messageRecu,"([%d:=-]+)");
							    local numSpecialInfo, valeurSpecialInfo;
						        if message then
						            -- Parcours le message
									for parametre in string.gfind(message,"%d+=%-?[%d]+") do
										-- Controle si les valeurs sont valides
									    local s,l,c,v = string.find(parametre,"(%d+)=(%-?[%d]+)");
									    -- Si c'est la valeur
									    if c=="0" and tonumber(v)>=0 and tonumber(v)<=255 then
											slot.valeur = tonumber(v);
										end
										-- Si c'est la commande
									    if c=="1" then
											if slot.valeur then -- si une valeur est stocke
												-- execute la commande  2 arguments
												local valeurCommande = (1 - tonumber(slot.valeur)*2/256);

												if valeurCommande>=-1 and valeurCommande<=1 then
													-- Si la valeur est correct excute la commande
													log(string.format("Reoi la commande du client(id=%s) : %s(%d,%f)\n",
													slot.idClient,LO_Commands[tonumber(v) + 500],tonumber(v),tonumber(valeurCommande)));
													LoSetCommand(tonumber(v),valeurCommande);
												end
											else
												if tonumber(v) > 0 and tonumber(v) <= 431 then
													-- execute la commande  1 arguments
													log(string.format("Reoi la commande du client(id=%s) : %s(%d)\n",
													slot.idClient,LO_Commands[tonumber(v)],tonumber(v)));
													LoSetCommand(tonumber(v));
												end
											end
									        -- Vide le cache valeur du client
											slot.valeur = nil;
										end
										if c=="5" then -- 10/05/2008
											numSpecialInfo = tonumber(string.sub(v,1,1));
											valeurSpecialInfo = tonumber(string.sub(v,2));
											log(string.format("Reoi la commande du client(id=%s) : (%d,%d)\n",
													slot.idClient,numSpecialInfo,valeurSpecialInfo));
											self.specialInfos[numSpecialInfo] = valeurSpecialInfo;
										end
									end
			                    end
							elseif typeMessage == "Arn.Inicio" then
							    --------------------------------------------------------
								-- Type = Arn.Inicio:                                 --
								--------------------------------------------------------
		      					log(string.format("Message du client(id:%s) : %s.\n",slot.idClient,messageRecu));
								-- Controle si le message est valide
								local s,l,message = string.find(messageRecu,"([%d:]+)");
							    if message then
									slot.inicio = slot.inicio..message;
									slot.initInicio = true;
								end
							else
		                        log(string.format("Message non valide du client(id:%s) : %s.\n",slot.idClient,messageRecu))
							end
						end
					else
						self.slotClients[n] = "libre";
                        -- Dcrmente le compteur des clients
						self.nombreClient = self.nombreClient - 1;
						log(string.format("Slot %d libr\n",n));
					end
				end
			end
			self.recupereInfosLockon(self);
		end
	end,
	------------------------------------------------------------------------
 	--    Fonction pour ajouter un client       						  --
	------------------------------------------------------------------------
	ajouterNouveauClient = function(self,client,slot)
		-- Configure le temps d'attente du client  0 pour
		-- ne pas bloquer lockon
		client:settimeout(0);
		-- Dfinit les paramtres du client
		self.slotClients[slot] =
			{
				tcpClient = client, -- Handle du client
				idClient = self.recupererId(client), -- Id Client
				initInicio = false, --
				inicio = "", 		-- Stock la liste des infos retour du client
				valeur=nil 			-- Cache ou est stoke la valeur de commande
			};
		-- Incrmente le compteur des clients
		self.nombreClient = self.nombreClient + 1;
		log(string.format("Nouveau client(id:%s slot:%d) s'est connect.\n",
		self.slotClients[slot].idClient,slot))
	end,
	------------------------------------------------------------------------
 	--    Fonction pour rcuprer l'id du client						  --
	------------------------------------------------------------------------
	recupererId = function(client)
		s,l,id = string.find(tostring(client),"( %w+)")
	    return string.sub(tostring(client),s+1,l)
	end,
    ------------------------------------------------------------------------
 	--    Fonction pour rechercher un slot disponible				      --
	------------------------------------------------------------------------
	rechercheSlot = function(self)
	    -- Recherche un slot dans les clients inactifs
	    for n,slot in pairs(self.slotClients) do
    		if slot == "libre" then
				return n
			end
		end
		log("Aucun slot disponible\n");
		return nil
	end,
	------------------------------------------------------------------------
 	--    Fonction pour recuperer les infos de lockon   				  --
	------------------------------------------------------------------------
	recupereInfosLockon = function(self)
	    local _Coalition={["Allies"]=0, ["Enemies"]=1}
		self.envoyerInfo("10",LoGetModelTime())--ok
		self.envoyerInfo("11",LoGetMissionStartTime())--ok
		if LoGetPlayerPlaneId() then
			local obj = LoGetObjectById(LoGetPlayerPlaneId())
			local myXCoord, myZCoord = self.getXYCoords(obj.LatLongAlt.Lat, obj.LatLongAlt.Long)
			self.envoyerInfo("12",obj.Type)--ok
			-- Objets subtype :
			--	Airplane = 1, Helicopter = 2, Moving = 8, Standing = 9, Tank = 17, SAM	= 16,
 			--	Ship = 12, Missile = 4, Bomb = 5, Shell = 6, Rocket = 7, Airdrome = 13
			self.envoyerInfo("13",obj.Subtype)--ok
			--self.envoyerInfo("14",obj.Country)
			self.envoyerInfo("15",_Coalition[obj.Coalition])
			self.envoyerInfo("16",myXCoord*100)--ok
			self.envoyerInfo("17",myZCoord*100)--ok
			self.envoyerInfo("18",obj.LatLongAlt.Lat*100)--ok
			self.envoyerInfo("19",obj.LatLongAlt.Long*100)--ok
			self.envoyerInfo("20",obj.LatLongAlt.Alt*100)--ok
			self.envoyerInfo("21",obj.Heading*100)--ok
		end

		self.envoyerInfo("22",LoGetIndicatedAirSpeed()*100)--ok
		self.envoyerInfo("23",LoGetTrueAirSpeed()*100)--ok
		self.envoyerInfo("24",LoGetAltitudeAboveSeaLevel()*100)
		self.envoyerInfo("25",LoGetAltitudeAboveGroundLevel()*100)
		self.envoyerInfo("26",LoGetAngleOfAttack()*100)
		self.envoyerInfo("27",LoGetAccelerationUnits()*100)
		self.envoyerInfo("28",LoGetVerticalVelocity()*100)
		self.envoyerInfo("29",LoGetMachNumber()*10)--ok
		-- *****************************
		pitch,bank,yaw = LoGetADIPitchBankYaw()
		self.envoyerInfo("30",pitch*100)--ok
		self.envoyerInfo("31",bank*100)--ok
		self.envoyerInfo("32",yaw*100)--ok
		self.envoyerInfo("33",LoGetMagneticYaw()*100)
		self.envoyerInfo("34",LoGetGlideDeviation()*100)
		self.envoyerInfo("35",LoGetSideDeviation()*100)
		self.envoyerInfo("36",LoGetSlipBallPosition()*100)
		self.envoyerInfo("37",LoGetBasicAtmospherePressure())
		-- *****************************
		_LoGetControlPanel_HSI = LoGetControlPanel_HSI()
		self.envoyerInfo("38",_LoGetControlPanel_HSI.ADF*100)
		self.envoyerInfo("39",_LoGetControlPanel_HSI.RMI*100)
		self.envoyerInfo("40",_LoGetControlPanel_HSI.Compass*100)
		-- *****************************
		_LoGetEngineInfo=LoGetEngineInfo()
		self.envoyerInfo("41",_LoGetEngineInfo.RPM.left*10)--ok
		self.envoyerInfo("42",_LoGetEngineInfo.RPM.right*10)--ok
		self.envoyerInfo("43",_LoGetEngineInfo.Temperature.left*10)--ok
		self.envoyerInfo("44",_LoGetEngineInfo.Temperature.right*10)--ok
		self.envoyerInfo("45",_LoGetEngineInfo.HydraulicPressure.left*10)--ok
		self.envoyerInfo("46",_LoGetEngineInfo.HydraulicPressure.right*10)--ok
		self.envoyerInfo("47",_LoGetEngineInfo.fuel_internal*100)--ok
		self.envoyerInfo("48",_LoGetEngineInfo.fuel_external*100)--ok
		-- *****************************
		local _LoGetRoute = LoGetRoute()
		if _LoGetRoute then
			self.envoyerInfo("49",_LoGetRoute.goto_point.this_point_num+1); -- 10/05/2008
			self.envoyerInfo("50",_LoGetRoute.goto_point.world_point.x*100); -- 10/05/2008
			self.envoyerInfo("51",_LoGetRoute.goto_point.world_point.y*100); --10/05/2008
			self.envoyerInfo("52",_LoGetRoute.goto_point.world_point.z*100); -- 10/05/2008
			self.envoyerInfo("53",_LoGetRoute.goto_point.speed_req)
			self.envoyerInfo("54",_LoGetRoute.goto_point.estimated_time)
			self.envoyerInfo("55",_LoGetRoute.goto_point.next_point_num)
			self.envoyerInfo("56",table.getn(_LoGetRoute.route))
			for num,wpt in pairs(_LoGetRoute.route) do
			    if self.specialInfos[4]==num then -- 10/05/2008
					self.envoyerInfo("57",wpt.world_point.x*100); -- 10/05/2008
					self.envoyerInfo("58",wpt.world_point.y*100); -- 10/05/2008
					self.envoyerInfo("59",wpt.world_point.z*100); -- 10/05/2008
					self.envoyerInfo("60",wpt.speed_req)
					self.envoyerInfo("61",wpt.estimated_time)
					self.envoyerInfo("62",wpt.next_point_num)
					self.envoyerInfo("63",wpt.this_point_num)
				end
			end
		end
		-- ******************************
		local _LoGetNavigationInfo = LoGetNavigationInfo()
		if _LoGetNavigationInfo then
			local _Modes = 	{
					 			NAV=0, BVR=1, CAC=2, LNG=3, A2G=4, ROUTE=5, ARRIVAL=6,
								LANDING=7, GUN=8, RWS=9, TWS=10, STT=11, VERTICAL_SCAN=12,
								BORE=13, HELMET=14, FLOOD=15, ETS=16, PINPOINT=17, UNGUIDED=18,
								FOLLOW_ROUTE=19, BARO_HOLD=20, RADIO_HOLD=21, BARO_ROLL_HOLD=22,
								HORIZON_HOLD=23, PITCH_BANK_HOLD=24
							}
			local _strMaster = _LoGetNavigationInfo.SystemMode.master
			local _strSubmode = _LoGetNavigationInfo.SystemMode.submode
			local _strACS = _LoGetNavigationInfo.ACS.mode
			local _ResultMode = 0
			if (_strMaster ~= "OFF") then
				_ResultMode = _ResultMode + math.pow(2,_Modes[_strMaster])
			end
			if (_strSubmode ~= "OFF") then
				_ResultMode = _ResultMode + math.pow(2,_Modes[_strSubmode])
			end
			if (_strACS ~= "OFF") then
				_ResultMode = _ResultMode + math.pow(2,_Modes[_strACS])
			end
			self.envoyerInfo("64",_ResultMode) -- Voir dtails dans notice
			self.envoyerInfo("65",_LoGetNavigationInfo.Requirements.roll*100)
			self.envoyerInfo("66",_LoGetNavigationInfo.Requirements.pitch*100)
			self.envoyerInfo("67",_LoGetNavigationInfo.Requirements.speed*100)
			self.envoyerInfo("68",_LoGetNavigationInfo.Requirements.vertical_speed*100)
			self.envoyerInfo("69",_LoGetNavigationInfo.Requirements.altitude*100)
			self.envoyerInfo("70",_LoGetNavigationInfo.ACS.autothrust and 1 or 0)
		end
		-- *******************************
		_LoGetMCPState = LoGetMCPState()
		local _compteur = 0
		local _MCPState = 0
		for n,v in pairs(_LoGetMCPState) do
		--log(tostring(n)..":".._compteur.."\n");
			if (v) then
			
				_MCPState = _MCPState + math.pow(2,_compteur)
			end
			_compteur = _compteur + 1
		end
		self.envoyerInfo("71",_MCPState) -- Voir dtails dans notice
		-- *******************************
		local _LoGetTargetInformation = LoGetTargetInformation()
		self.envoyerInfo("72",table.getn(_LoGetTargetInformation))
		for i,cur in pairs(_LoGetTargetInformation) do
			--Log(string.format("-> Contact n %d :\n",i))
			if self.specialInfos[1]==i then -- 10/05/2008
				local obj = LoGetObjectById(cur.ID)
				local targetXCoord, targetZCoord = self.getXYCoords(obj.LatLongAlt.Lat, obj.LatLongAlt.Long)
				self.envoyerInfo("73",obj.Type)
				-- Objets subtype :
				--	Airplane = 1, Helicopter = 2, Moving = 8, Standing = 9, Tank = 17, SAM	= 16,
	 			--	Ship = 12, Missile = 4, Bomb = 5, Shell = 6, Rocket = 7, Airdrome = 13
				self.envoyerInfo("74",obj.Subtype)
				--self.envoyerInfo("75",obj.Country)
				self.envoyerInfo("76",_Coalition[obj.Coalition])
				self.envoyerInfo("77",targetXCoord*100)
				self.envoyerInfo("78",targetZCoord*100)
				self.envoyerInfo("79",obj.LatLongAlt.Lat*100)
				self.envoyerInfo("80",obj.LatLongAlt.Long*100)
				self.envoyerInfo("81",obj.LatLongAlt.Alt*100)
				self.envoyerInfo("82",obj.Heading*100)
				self.envoyerInfo("83",cur.ID)
				self.envoyerInfo("84",tonumber(cur.type.level1..cur.type.level2..cur.type.level3..cur.type.level4))
				self.envoyerInfo("85",cur.country)
				self.envoyerInfo("86",cur.position.x.x*100)
				self.envoyerInfo("87",cur.position.x.y*100)
				self.envoyerInfo("88",cur.position.x.z*100)
				self.envoyerInfo("89",cur.position.y.x*100)
				self.envoyerInfo("90",cur.position.y.y*100)
				self.envoyerInfo("91",cur.position.y.z*100)
				self.envoyerInfo("92",cur.position.z.x*100)
				self.envoyerInfo("93",cur.position.z.y*100)
				self.envoyerInfo("94",cur.position.z.z*100)
				self.envoyerInfo("95",cur.position.p.x*100)
				self.envoyerInfo("96",cur.position.p.y*100)
				self.envoyerInfo("97",cur.position.p.z*100)
				self.envoyerInfo("98",cur.velocity.x*100)
				self.envoyerInfo("99",cur.velocity.y*100)
				self.envoyerInfo("100",cur.velocity.z*100)
				self.envoyerInfo("101",cur.distance)
				self.envoyerInfo("102",cur.convergence_velocity)
				self.envoyerInfo("103",cur.mach)
				self.envoyerInfo("104",cur.delta_psi)
				self.envoyerInfo("105",cur.fim)
				self.envoyerInfo("106",cur.fin)
				self.envoyerInfo("107",cur.flags)
				self.envoyerInfo("108",cur.reflection)
				self.envoyerInfo("109",cur.course)
				self.envoyerInfo("110",cur.isjamming)
				self.envoyerInfo("111",cur.start_of_lock)
				self.envoyerInfo("112",cur.forces.x*100)
				self.envoyerInfo("113",cur.forces.y*100)
				self.envoyerInfo("114",cur.forces.z*100)
				self.envoyerInfo("115",cur.updates_number)
				self.envoyerInfo("116",i); -- Target en cours
			end
		end

		-- *******************************
		local _LoGetLockedTargetInformation = LoGetLockedTargetInformation()
		self.envoyerInfo("117",table.getn(_LoGetLockedTargetInformation))
		for i,cur in pairs(_LoGetLockedTargetInformation) do
		    if self.specialInfos[2]==i then -- 10/05/2008
				local obj = LoGetObjectById(cur.ID)
				local targetXCoord, targetZCoord = self.getXYCoords(obj.LatLongAlt.Lat, obj.LatLongAlt.Long)
				self.envoyerInfo("118",obj.Type)
				-- Objets subtype :
				--	Airplane = 1, Helicopter = 2, Moving = 8, Standing = 9, Tank = 17, SAM	= 16,
	 			--	Ship = 12, Missile = 4, Bomb = 5, Shell = 6, Rocket = 7, Airdrome = 13
				self.envoyerInfo("119",obj.Subtype)
				--self.envoyerInfo("120",obj.Country)
				self.envoyerInfo("121",_Coalition[obj.Coalition])
				self.envoyerInfo("122",targetXCoord*100)
				self.envoyerInfo("123",targetZCoord*100)
				self.envoyerInfo("124",obj.LatLongAlt.Lat*100)
				self.envoyerInfo("125",obj.LatLongAlt.Long*100)
				self.envoyerInfo("126",obj.LatLongAlt.Alt*100)
				self.envoyerInfo("127",obj.Heading*100)
				self.envoyerInfo("128",cur.ID)
				self.envoyerInfo("129",tonumber(cur.type.level1..cur.type.level2..cur.type.level3..cur.type.level4))
				self.envoyerInfo("130",cur.country)
				self.envoyerInfo("131",cur.position.x.x*100)
				self.envoyerInfo("132",cur.position.x.y*100)
				self.envoyerInfo("133",cur.position.x.z*100)
				self.envoyerInfo("134",cur.position.y.x*100)
				self.envoyerInfo("135",cur.position.y.y*100)
				self.envoyerInfo("136",cur.position.y.z*100)
				self.envoyerInfo("137",cur.position.z.x*100)
				self.envoyerInfo("138",cur.position.z.y*100)
				self.envoyerInfo("139",cur.position.z.z*100)
				self.envoyerInfo("140",cur.position.p.x*100)
				self.envoyerInfo("141",cur.position.p.y*100)
				self.envoyerInfo("142",cur.position.p.z*100)
				self.envoyerInfo("143",cur.velocity.x*100)
				self.envoyerInfo("144",cur.velocity.y*100)
				self.envoyerInfo("145",cur.velocity.z*100)
				self.envoyerInfo("146",cur.distance)
				self.envoyerInfo("147",cur.convergence_velocity)
				self.envoyerInfo("148",cur.mach)
				self.envoyerInfo("149",cur.delta_psi)
				self.envoyerInfo("150",cur.fim)
				self.envoyerInfo("151",cur.fin)
				self.envoyerInfo("152",cur.flags)
				self.envoyerInfo("153",cur.reflection)
				self.envoyerInfo("154",cur.course)
				self.envoyerInfo("155",cur.isjamming)
				self.envoyerInfo("156",cur.start_of_lock)
				self.envoyerInfo("157",cur.forces.x*100)
				self.envoyerInfo("158",cur.forces.y*100)
				self.envoyerInfo("159",cur.forces.z*100)
				self.envoyerInfo("160",cur.updates_number)
				self.envoyerInfo("161",i); -- LockedTarget en cours
			end
		end
		-- *************************
		_LoGetTWSInfo = LoGetTWSInfo()
		--local _SignalType ={scan=0,lock=1,missile_radio_guided=2,track_while_scan=3}
		local _SignalType ={scan=0,lock=0,missile_radio_guided=0,track_while_scan=0}
		local _SignalTypeValeur ={scan=0,lock=1,missile_radio_guided=2,track_while_scan=3}
		local _SignalTypeCode = 0;
		self.envoyerInfo("162",_LoGetTWSInfo.Mode) -- (0 - all|1 - lock only|2 - launch only)
		self.envoyerInfo("163",table.getn(_LoGetTWSInfo.Emitters)) --
		for k,v in pairs(_LoGetTWSInfo.Emitters) do
			if self.specialInfos[3]==k then -- 10/05/2008
			    local obj = LoGetObjectById(v.ID)
				local EmitterXCoord,EmitterZCoord = self.getXYCoords(obj.LatLongAlt.Lat, obj.LatLongAlt.Long)
				self.envoyerInfo("164",obj.Type)
				-- Objets subtype :
				--	Airplane = 1, Helicopter = 2, Moving = 8, Standing = 9, Tank = 17, SAM	= 16,
	 			--	Ship = 12, Missile = 4, Bomb = 5, Shell = 6, Rocket = 7, Airdrome = 13
				self.envoyerInfo("165",obj.Subtype)
				--self.envoyerInfo("166",obj.Country)
				self.envoyerInfo("167",_Coalition[obj.Coalition])
				self.envoyerInfo("168",EmitterXCoord*100)
				self.envoyerInfo("169",EmitterZCoord*100)
				self.envoyerInfo("170",obj.LatLongAlt.Lat*100)
				self.envoyerInfo("171",obj.LatLongAlt.Long*100)
				self.envoyerInfo("172",obj.LatLongAlt.Alt*100)
				self.envoyerInfo("173",obj.Heading*100)
				self.envoyerInfo("174",v.ID)
				self.envoyerInfo("175",tonumber(v.Type.level1..v.Type.level2..v.Type.level3..v.Type.level4))
				self.envoyerInfo("176",v.Power*1000)
				self.envoyerInfo("177",v.Azimuth*1000)
				self.envoyerInfo("178",v.Priority)
				self.envoyerInfo("179",_SignalType[v.SignalType])
			end
			if _SignalType[v.SignalType]==0 then
				_SignalType[v.SignalType] = 1;
				_SignalTypeCode = _SignalTypeCode + math.pow(2, _SignalTypeValeur[v.SignalType])
			end


			self.envoyerInfo("180",k); -- Emitter en cours
		end

		self.envoyerInfo("181",_SignalTypeCode) --
		-- ***************************
		local _LoGetPayloadInfo = LoGetPayloadInfo();
		if _LoGetPayloadInfo then
			local _PylonActuel = _LoGetPayloadInfo.CurrentStation;
			local _TypeArme = 0;
			local _TypeArmeSel = 0;
			local _QuantiteArmeSel = 0;
			if _PylonActuel ~= 0 then
				_TypeArme = _LoGetPayloadInfo.Stations[_PylonActuel].weapon;
			    _TypeArmeSel = tonumber(_TypeArme.level1.._TypeArme.level2.._TypeArme.level3.._TypeArme.level4);
				_QuantiteArmeSel = _LoGetPayloadInfo.Stations[_PylonActuel].count;
			end
			local _PanneauArmeDispo = 0;
			local _PanneauArmeSelDispo = 0;
	        self.envoyerInfo("182",_PylonActuel);                   -- Pylon slectionn
	        self.envoyerInfo("183",_TypeArmeSel);                   -- Type Arme slectionne
	        self.envoyerInfo("184",_QuantiteArmeSel);				-- Quantit arme slectionn
	        self.envoyerInfo("185",table.getn(_LoGetPayloadInfo.Stations)); 	-- Nombre de pylons
	   		if _LoGetPayloadInfo then
				for i_st,st in pairs (_LoGetPayloadInfo.Stations) do
					local _Container = 0;
					local _TypeArme = tonumber(st.weapon.level1..st.weapon.level2..st.weapon.level3..st.weapon.level4);
					if st.container then _Container = 1; end
					-- Panneau Arme slectionne
					if (_TypeArme == _TypeArmeSel and _TypeArmeSel ~= 0) then
						_PanneauArmeSelDispo = _PanneauArmeSelDispo + math.pow(2,(i_st-1));
					end
					--  Panneau Arme disponible
					if st.count > 0 and _TypeArme ~= 134310 then
					    _PanneauArmeDispo = _PanneauArmeDispo + math.pow(2,(i_st-1));
					end
                    if self.specialInfos[5]==i_st then -- 10/05/2008
						self.envoyerInfo("186",_Container);
						self.envoyerInfo("187",_TypeArme);
						self.envoyerInfo("188",st.count);
						self.envoyerInfo("189",i_st);
					end
				end
				self.envoyerInfo("190",_PanneauArmeSelDispo);
				self.envoyerInfo("191",_PanneauArmeDispo);
			end
		end
		-- [F_15]    = {1, 11, 10, 2, 3, 9, 4, 5, 7, 8, 6}
		-- [Su_27]   = {10, 1, 9, 2, 3, 8, 4, 7, 6, 5}
		-- [Su_33]   = {12, 1, 11, 2, 3, 10, 4, 9, 5, 8, 7, 6}
		-- [Su_25]   = {1, 10, 2, 9, 3, 8, 4, 7, 5, 6}
		-- [A_10]    = {1, 11, 2, 10, 3, 9, 4, 8, 5, 7, 6}
		-- [Su_25T]  = {1, 11, 2, 10, 3, 9, 4, 8, 5, 7, 6}
	end,
	------------------------------------------------------------------------
	--    Fonction pour ajouter les infos aux clients                     --
	--	  (Seulements ceux qui ont changes)        					  --
	------------------------------------------------------------------------
	envoyerInfo = function(strAttribut,valeur)
		local strValeur = string.format("%d",valeur);
		for n,client in pairs(LoiocpServeur.slotClients) do
			if LoiocpServeur.slotClients[n] ~= "libre" then
				if (strValeur ~= LoiocpServeur.ancieneValeur[strAttribut]) or client.initInicio then
					-- Construit la chaine d'envoi du client d'aprs inicio
					if string.find(client.inicio,":"..strAttribut..":") then
						client.tcpClient:send(string.format("Arn.Resp:%s=%s:\n",strAttribut,strValeur));
						--log(string.format("Arn.Resp:%s=%s:\n",strAttribut,strValeur));
					end
				end
			end
		end
		LoiocpServeur.ancieneValeur[strAttribut] = strValeur ;
	end,
	------------------------------------------------------------------------
	--    Fonction pour le calcul des coordonnes rcuprer dans LOVP     --
	--	  Merci  Mnemonic                           					  --
	------------------------------------------------------------------------
	getXYCoords = function(inLatitudeDegrees, inLongitudeDegrees) -- args: 2 numbers // Return two value in order: X, Y
        local pi = 3.141592

		local zeroX = 5000000
		local zeroZ = 6600000

		local centerX = 11465000 - zeroX --circle center
		local centerZ =  6500000 - zeroZ

		local pnSxW_X = 4468608 - zeroX -- point 40dgN : 24dgE
		local pnSxW_Z = 5730893 - zeroZ

		local pnNxW_X = 5357858 - zeroX -- point 48dgN : 24dgE
		local pnNxW_Z = 5828649 - zeroZ

		local pnSxE_X = 4468608 - zeroX -- point 40dgN : 42dgE
		local pnSxE_Z = 7269106 - zeroZ

		local pnNxE_X = 5357858 - zeroX -- point 48dgN : 42dgE
		local pnNxE_Z = 7171350 - zeroZ

		local lenNorth = math.sqrt((pnNxW_X-centerX)*(pnNxW_X-centerX) + (pnNxW_Z-centerZ)*(pnNxW_Z-centerZ))
		local lenSouth = math.sqrt((pnSxW_X-centerX)*(pnSxW_X-centerX) + (pnSxW_Z-centerZ)*(pnSxW_Z-centerZ))
		local lenN_S = lenSouth - lenNorth

		local RealAngleMaxLongitude = math.atan ((pnSxW_Z - centerZ)/(pnSxW_X - centerX)) * 180/pi
		-- borders
		local EndWest = 24
		local EndEast = 42
		local EndNorth = 48
		local EndSouth = 40
		local MiddleLongitude = (EndWest + EndEast) / 2
		local ToLengthN_S = ((EndNorth - EndSouth) / lenN_S)
		local ToAngleW_E = (MiddleLongitude - EndWest) / RealAngleMaxLongitude

		local ToDegree = 360/(2*pi)
	    -- Lo coordinates system
	    local realAng = (inLongitudeDegrees - MiddleLongitude) / ToAngleW_E / ToDegree;
	    local realLen = lenSouth - (inLatitudeDegrees - EndSouth) / ToLengthN_S;
	    local outX = centerX - realLen * math.cos (realAng);
	    local outZ = centerZ + realLen * math.sin (realAng);
	    return outX, outZ
	end
}

SIOCClient = {
 	SOCKET_PORT = 8090,			   -- Port du client SIOC
 	SOCKET_HOST = "localhost",	   -- Host du client SIOC
	tcpClient = nil,               -- Handle du client
	tempsReconnection = 5,         -- Temps d'attente pour tentative de connection
	--inicio =  ":134:135:136:137:138:139:140:141:142:143:", --":10:11:12:13:14:15:16:17:18:19:20:21:22:23:24:25:26:27:28:29:30:31:32:33:34:35:36:37:38:39:40:41:42:43:44:45:46:47:48:49:50:51:52:53:54:55:56:57:58:59:60:61:62:63:64:65:66:67:68:69:70:71:72:73:74:75:76:77:78:79:80:81:82:83:84:85:86:87:88:89:90:91:92:93:94:95:96:97:98:99:100:101:102:103:104:105:106:107:108:109:110:111:112:113:114:115:116:117:118:119:120:121:122:123:124:125:126:127:128:129:130:131:132:133:134:135:136:137:138:139:140:141:142:143:144:145:146:147:148:149:150:151:152:153:154:155:156:157:158:159:160:161:162:163:164:165:166:167:168:169:170:171:172:173:174:175:176:177:178:179:180:181:182:183:184:",
    inicio = ":10:11:12:13:14:15:16:17:18:19:20:21:22:23:24:25:26:27:28:29:30:31:32:33:34:35:36:37:38:39:40:41:42:43:44:45:46:47:48:49:50:51:52:53:54:55:56:57:58:59:60:61:62:63:64:65:66:67:68:69:70:71:72:73:74:75:76:77:78:79:80:81:82:83:84:85:86:87:88:89:90:91:92:93:94:95:96:97:98:99:100:101:102:103:104:105:106:107:108:109:110:111:112:113:114:115:116:117:118:119:120:121:122:123:124:125:126:127:128:129:130:131:132:133:134:135:136:137:138:139:140:141:142:143:144:145:146:147:148:149:150:151:152:153:154:155:156:157:158:159:160:161:162:163:164:165:166:167:168:169:170:171:172:173:174:175:176:177:178:179:180:181:182:183:184:185:186:187:188:189:190:191:",
------------------------------------------------------------------------
 	--    Fonction pour se connecter au SIOC			   				  --
	------------------------------------------------------------------------
    initConnection = function(self)
		if self.tcpClient == nil then
			log(string.format("Connection au SIOC Host:%s, Port:%d\n",self.SOCKET_HOST,self.SOCKET_PORT));
            self.tcpClient = socket.connect(self.SOCKET_HOST,self.SOCKET_PORT);
	  		if self.tcpClient ~= nil then
				socket.try(self.tcpClient:setoption("tcp-nodelay",true)) ;
         		socket.try(self.tcpClient:send("Arn.Inicio:0:1:5:\n")); -- 10/05/2008
         		data,e= self.tcpClient:receive()
			    if data == "Arn.Vivo:" then
					socket.try(self.tcpClient:send("Arn.Vivo:\n"))
					data,e= self.tcpClient:receive()
					if data ~= nil then
					    log("Connection SIOC : Russi\n");
						slot = LoiocpServeur.rechercheSlot(LoiocpServeur);
	  		    		socket.try(self.tcpClient:settimeout(0));
	  		    		LoiocpServeur.ajouterNouveauClient(LoiocpServeur,self.tcpClient,slot);
	  		    		LoiocpServeur.slotClients[slot].inicio = self.inicio; -- Stock la liste des infos retour du client
	  		    	else
						log("Connection SIOC : Echec\n");
					end
				else
				log("Connection SIOC : Echec\n");
				end
			else
			    log("Connection SIOC : Echec\n");
			end
		end
	end
}

------------------------------------------------------------------------
--    Fonction Log													  --
------------------------------------------------------------------------
function log(message)
	if DEBUG_MODE and not fichierServeurLog then
       	fichierServeurLog = io.open("./Temp/Export.log", "w");
		if fichierServeurLog then
			io.output(fichierServeurLog);
			io.write("**************************************************************************\n");
			io.write("*     Fichier log du serveur IOCP                                        *\n");
			io.write("*     Par Lecreole  -  http://charles.contact.free.fr                    *\n");
			io.write("*     Version 1.1.5 du 13/05/2008                                       *\n");
			io.write("**************************************************************************\n\n");
			io.write(string.format("Infos joueur : %s\n",LoGetObjectById(LoGetPlayerPlaneId()).Name));
			io.write("Emports :\n");
			local stations = LoGetPayloadInfo();
			if stations then
				for i_st,st in pairs (stations.Stations) do
					local name = LoGetNameByType(st.weapon.level1,st.weapon.level2,st.weapon.level3,st.weapon.level4);
					if name then
					io.write(string.format("\t%s ,quantit = %d \n",name,st.count))
					else
					io.write(string.format("\t{%d,%d,%d,%d} ,quantit = %d \n", st.weapon.level1,st.weapon.level2,st.weapon.level3,st.weapon.level4,st.count))
					end
				end
			end 
			io.write("\n\n-- Dbut log --\n\n");
		end
    end
	if fichierServeurLog then
        io.write(string.format(" %s - %s",os.date("%d/%m/%y %H:%M:%S"),message));
	end
end

------------------------------------------------------------------------
--    Dmarrage du serveur et client SIOC							  --
------------------------------------------------------------------------
do
	local PrevLuaExportStart=LuaExportStart;
 	LuaExportStart=function()
		log(socket.VERSION.."\n");
		LoiocpServeur:creerIOCPServeur();
		if MODULE_SIOC then
	  		SIOCClient:initConnection();
		end
		if PrevLuaExportStart then
			PrevLuaExportStart();
		end
	end
end

------------------------------------------------------------------------
--    Serveur model timer               							  --
------------------------------------------------------------------------
do
	local PrevLuaExportAfterNextFrame=LuaExportAfterNextFrame;
	LuaExportAfterNextFrame=function()
		if MODULE_SIOC then
			temps = LoGetModelTime();
			if SIOCClient.tcpClient ~= nil then
				local ip, err = SIOCClient.tcpClient:getsockname();
				if ip == "0.0.0.0" then
					SIOCClient.tcpClient = nil;
					SIOCClient.tempsReconnection = temps + 5;
				end
			end

			if SIOCClient.tcpClient == nil  and temps > SIOCClient.tempsReconnection then
				SIOCClient:initConnection();
				--SIOCClient.tempsReconnection = temps + 5;
			end
		end
		LoiocpServeur:demarrerServeurTcp();

		if PrevLuaExportAfterNextFrame then
			PrevLuaExportAfterNextFrame();
		end
	end
end

------------------------------------------------------------------------
--    Fermeture des slots clients et du serveur	     				  --
------------------------------------------------------------------------
do
	local PrevLuaExportStop=LuaExportStop;

	LuaExportStop=function()
		
		if PrevLuaExportStop then
			PrevLuaExportStop();
		end
	end
end

LO_Commands = 
{
-- Some analogous joystick/mouse input commands	

	 [501] = "joystick pitch",
	 [502] = "joystick roll",
	 [503] = "joystick rudder",

-- Thrust values are inverted for some internal reasons, sorry.

	 [504] = "joystick thrust (both engines)",
	 [505] = "joystick left engine thrust",
	 [506] = "joystick right engine thrust",
	 [507] = "mouse camera rotate left/right",
	 [508] = "mouse camera rotate up/down",
	 [509] = "mouse camera zoom",
	 [510] = "joystick camera rotate left/right",
	 [511] = "joystick camera rotate up/down",
	 [512] = "joystick camera zoom",
	 [513] = "mouse pitch",
	 [514] = "mouse roll",
	 [515] = "mouse rudder",

-- Thrust values are inverted for some internal reasons, sorry.

	 [516] = "mouse thrust (both engines)",
	 [517] = "mouse left engine thrust",
	 [518] = "mouse right engine thrust",
	 [519] = "mouse trim pitch",
	 [520] = "mouse trim roll",
	 [521] = "mouse trim rudder",
	 [522] = "joystick trim pitch",
	 [523] = "joystick trim roll",
	 [524] = "trim rudder",
	 [525] = "mouse rotate radar antenna left/right",
	 [526] = "mouse rotate radar antenna up/down",
	 [527] = "joystick rotate radar antenna left/right",
	 [528] = "joystick rotate radar antenna up/down",
	 [529] = "mouse MFD zoom",
	 [530] = "joystick MFD zoom",
	 [531] = "mouse move selecter left/right",
	 [532] = "mouse move selecter up/down",
	 [533] = "joystick move selecter left/right",
	 [534] = "joystick move selecter up/down",

-- Some discrete keyboard input commands (value is absent)	

	 [7] = "Cockpit view",
	 [8] = "External view",
	 [9] = "Fly-by view",
	 [10] = "Ground units view",
	 [11] = "Civilian transport view",
	 [12] = "Chase view",
	 [13] = "Navy view",
	 [14] = "Close air combat view",
	 [15] = "Theater view",
	 [16] = "Airfield (free camera) view",
	 [17] = "Instruments panel view on",
	 [18] = "Instruments panel view off",
	 [19] = "Padlock toggle",
	 [20] = "Stop padlock (in cockpit only)",
	 [21] = "External view for my plane",
	 [22] = "Automatic chase mode for launched weapon",
	 [23] = "View allies only filter",
	 [24] = "View enemies only filter",
	 [26] = "View allies & enemies filter",
	 [28] = "Rotate the camera left fast",
	 [29] = "Rotate the camera right fast",
	 [30] = "Rotate the camera up fast",
	 [31] = "Rotate the camera down fast",
	 [32] = "Rotate the camera left slow",
	 [33] = "Rotate the camera right slow",
	 [34] = "Rotate the camera up slow",
	 [35] = "Rotate the camera down slow",
	 [36] = "Return the camera to default position",
	 [37] = "View zoom in fast",
	 [38] = "View zoom out fast",
	 [39] = "View zoom in slow",
	 [40] = "View zoom out slow",
	 [41] = "Pan the camera left",
	 [42] = "Pan the camera right",
	 [43] = "Pan the camera up",
	 [44] = "Pan the camera down",
	 [45] = "Pan the camera left slow",
	 [46] = "Pan the camera right slow",
	 [47] = "Pan the camera up slow",
	 [48] = "Pan the camera down slow",
	 [49] = "Disable panning the camera",
	 [50] = "Allies chat",
	 [51] = "Mission quit",
	 [52] = "Suspend/resume model time",
	 [53] = "Accelerate model time",
	 [54] = "Step by step simulation when model time is suspended",
	 [55] = "Take control in the track",
	 [57] = "Common chat",
	 [59] = "Altitude stabilization",
	 [62] = "Autopilot",
	 [63] = "Auto-thrust",
	 [64] = "Power up",
	 [65] = "Power down",
	 [68] = "Gear",
	 [69] = "Hook",
	 [70] = "Pack wings",
	 [71] = "Canopy",
	 [72] = "Flaps",
	 [73] = "Air brake",
	 [74] = "Wheel brakes on",
	 [75] = "Wheel brakes off",
	 [76] = "Release drogue chute",
	 [77] = "Drop snar",
	 [78] = "Wingtip smoke",
	 [79] = "Refuel on",
	 [80] = "Refuel off",
	 [81] = "Salvo",
	 [82] = "Jettison weapons",
	 [83] = "Eject",
	 [84] = "Fire on",
	 [85] = "Fire off",
	 [86] = "Radar",
	 [87] = "EOS",
	 [88] = "Rotate the radar antenna left",
	 [89] = "Rotate the radar antenna right",
	 [90] = "Rotate the radar antenna up",
	 [91] = "Rotate the radar antenna down",
	 [92] = "Center the radar antenna",
	 [93] = "Trim left",
	 [94] = "Trim right",
	 [95] = "Trim up",
	 [96] = "Trim down",
	 [97] = "Cancel trimming",
	 [98] = "Trim the rudder left",
	 [99] = "Trim the rudder right",
	 [100] = "Lock the target",
	 [101] = "Change weapon",
	 [102] = "Change target",
	 [103] = "MFD zoom in",
	 [104] = "MFD zoom out",
	 [105] = "Navigation mode",
	 [106] = "BVR mode",
	 [107] = "VS	mode",
	 [108] = "Bore mode",
	 [109] = "Helmet mode",
	 [110] = "FI0 mode",
	 [111] = "A2G mode",
	 [112] = "Grid mode",
	 [113] = "Cannon",
	 [114] = "Dispatch wingman] = complete mission and RTB",
	 [115] = "Dispatch wingman] = complete mission and rejoin",
	 [116] = "Dispatch wingman] = toggle formation",
	 [117] = "Dispatch wingman] = join up formation",
	 [118] = "Dispatch wingman] = attack my target",
	 [119] = "Dispatch wingman] = cover my six",
	 [120] = "Take off from ship",
	 [121] = "Cobra",
	 [122] = "Sound on/off        ",
	 [123] = "Sound recording on",
	 [124] = "Sound recording off",
	 [125] = "View right mirror on",
	 [126] = "View right mirror off",
	 [127] = "View left mirror on",
	 [128] = "View left mirror off",
	 [129] = "Natural head movement view",
	 [131] = "LSO view",
	 [135] = "Weapon to target view",
	 [136] = "Active jamming",
	 [137] = "Increase details level",
	 [138] = "Decrease details level",
	 [139] = "Scan zone left",
	 [140] = "Scan zone right",
	 [141] = "Scan zone up",
	 [142] = "Scan zone down",
	 [143] = "Unlock target",
	 [144] = "Reset master warning",
	 [145] = "Flaps on",
	 [146] = "Flaps off",
	 [147] = "Air brake on",
	 [148] = "Air brake off",
	 [149] = "Weapons view",
	 [150] = "Static objects view",
	 [151] = "Mission targets view",
	 [152] = "Info bar details",
	 [155] = "Refueling boom",
	 [156] = "HUD color selection",
	 [158] = "Jump to terrain view",
	 [159] = "Starts moving F11 camera forward",
	 [160] = "Starts moving F11 camera backward",
	 [161] = "Power up left engine",
	 [162] = "Power down left engine",
	 [163] = "Power up right engine",
	 [164] = "Power down right engine",
	 [169] = "Immortal mode",
	 [175] = "On-board lights",
	 [176] = "Drop snar once",
	 [177] = "Default cockpit angle of view",
	 [178] = "Jettison fuel tanks",
	 [179] = "Wingmen 	 s panel",
	 [180] = "Reverse objects switching in views",
	 [181] = "Forward objects switching in views",
	 [182] = "Ignore current object in views",
	 [183] = "View all ignored objects in views again",
	 [184] = "Padlock terrain point",
	 [185] = "Reverse the camera",
	 [186] = "Plane up",
	 [187] = "Plane down",
	 [188] = "Bank left",
	 [189] = "Bank right",
	 [190] = "Local camera rotation mode",
	 [191] = "Decelerate model time",
	 [192] = "Jump into the other plane",
	 [193] = "Nose down",
	 [194] = "Nose down end",
	 [195] = "Nose up",
	 [196] = "Nose up end",
	 [197] = "Bank left",
	 [198] = "Bank left end",
	 [199] = "Bank right",
	 [200] = "Bank right end",
	 [201] = "Rudder left",
	 [202] = "Rudder left end",
	 [203] = "Rudder right",
	 [204] = "Rudder right end",
	 [205] = "View up right",
	 [206] = "View down right",
	 [207] = "View down left",
	 [208] = "View up left",
	 [209] = "View stop",
	 [210] = "View up right slow",
	 [211] = "View down right slow",
	 [212] = "View down left slow",
	 [213] = "View up left slow",
	 [214] = "View stop slow",
	 [215] = "Stop trimming",
	 [226] = "Scan zone up right",
	 [227] = "Scan zone down right",
	 [228] = "Scan zone down left",
	 [229] = "Scan zone up left",
	 [230] = "Scan zone stop",
	 [231] = "Radar antenna up right",
	 [232] = "Radar antenna down right",
	 [233] = "Radar antenna down left",
	 [234] = "Radar antenna up left",
	 [235] = "Radar antenna stop",
	 [236] = "Save snap view angles",
	 [237] = "Cockpit panel view toggle",
	 [245] = "Coordinates units toggle",
	 [246] = "Disable model time acceleration",
	 [252] = "Automatic spin recovery",
	 [253] = "Speed retention",
	 [254] = "Easy landing",
	 [258] = "Threat missile padlock",
	 [259] = "All missiles padlock",
	 [261] = "Marker state",
	 [262] = "Decrease radar scan area",
	 [263] = "Increase radar scan area",
	 [264] = "Marker state plane",
	 [265] = "Marker state rocket",
	 [266] = "Marker state plane ship",
	 [267] = "Ask AWACS home airbase",
	 [268] = "Ask AWACS available tanker",
	 [269] = "Ask AWACS nearest target",
	 [270] = "Ask AWACS declare target",
	 [271] = "Easy radar",
	 [272] = "Auto lock on nearest aircraft",
	 [273] = "Auto lock on center aircraft",
	 [274] = "Auto lock on next aircraft",
	 [275] = "Auto lock on previous aircraft",
	 [276] = "Auto lock on nearest surface target",
	 [277] = "Auto lock on center surface target",
	 [278] = "Auto lock on next surface target",
	 [279] = "Auto lock on previous surface target",
	 [280] = "Change cannon rate of fire",
	 [281] = "Change ripple quantity",
	 [282] = "Change ripple interval",
	 [283] = "Switch master arm",
	 [284] = "Change release mode",
	 [285] = "Change radar mode RWS/TWS",
	 [286] = "Change RWR/SPO mode",
	 [288] = "Flight clock reset",
	 [289] = "Zoom in slow stop",
	 [290] = "Zoom out slow stop",
	 [291] = "Zoom in stop",
	 [292] = "Zoom out stop",
	 [295] = "View horizontal stop",
	 [296] = "View vertical stop",
	 [298] = "Jump to fly-by view",
	 [299] = "Camera jiggle",
	 [300] = "Cockpit illumination",
	 [308] = "Change ripple interval down",
	 [309] = "Engines start",
	 [310] = "Engines stop",
	 [311] = "Left engine start",
	 [312] = "Right engine start",
	 [313] = "Left engine stop",
	 [314] = "Right engine stop",
	 [315] = "Power on/off",
	 [316] = "Altimeter pressure increase",
	 [317] = "Altimeter pressure decrease",
	 [318] = "Altimeter pressure stop",
	 [321] = "Fast mouse in views",
	 [322] = "Slow mouse in views",
	 [323] = "Normal mouse in views",
	 [326] = "HUD only view",
	 [327] = "Recover my plane",
	 [328] = "Toggle gear light Near/Far/Off",
	 [331] = "Fast keyboard in views",
	 [332] = "Slow keyboard in views",
	 [333] = "Normal keyboard in views",
	 [334] = "Zoom in for external views",
	 [335] = "Stop zoom in for external views",
	 [336] = "Zoom out for external views",
	 [337] = "Stop zoom out for external views",
	 [338] = "Default zoom in external views",
	 [341] = "A2G combat view",
	 [342] = "Camera view up-left",
	 [343] = "Camera view up-right",
	 [344] = "Camera view down-left",
	 [345] = "Camera view down right",
	 [346] = "Camera pan mode toggle",
	 [347] = "Return the camera",
	 [348] = "Trains/cars toggle",
	 [349] = "Launch permission override",
	 [350] = "Release weapon",
	 [351] = "Stop release weapon",
	 [352] = "Return camera base",
	 [353] = "Camera view up-left slow",
	 [354] = "Camera view up-right slow",
	 [355] = "Camera view down-left slow",
	 [356] = "Camera view down-right slow",
	 [357] = "Drop flare once",
	 [358] = "Drop chaff once",
	 [359] = "Rear view",
	 [360] = "Scores window",
	 [386] = "PlaneStabPitchBank",
	 [387] = "PlaneStabHbarBank",
	 [388] = "PlaneStabHorizont",
	 [389] = "PlaneStabHbar",
	 [390] = "PlaneStabHrad",
	 [391] = "Active IR jamming on/off",
	 [392] = "Laser range-finder on/off",
	 [393] = "Night TV on/off(IR or LLTV)",
	 [394] = "Change radar PRF",
	 [395] = "Keep F11 camera altitude over terrain",
	 [396] = "SnapView0",
	 [397] = "SnapView1",
	 [398] = "SnapView2",
	 [399] = "SnapView3",
	 [400] = "SnapView4",
	 [401] = "SnapView5",
	 [402] = "SnapView6",
	 [403] = "SnapView7",
	 [404] = "SnapView8",
	 [405] = "SnapView9",
	 [406] = "SnapViewStop",
	 [407] = "F11 view binocular mode",
	 [408] = "PlaneStabCancel",
	 [409] = "ThreatWarnSoundVolumeDown",
	 [410] = "ThreatWarnSoundVolumeUp",
	 [411] = "F11 binocular view laser range-finder on/off",
	 [412] = "PlaneIncreaseBase_Distance",
	 [413] = "PlaneDecreaseBase_Distance",
	 [414] = "PlaneStopBase_Distance",
	 [425] = "F11 binocular view IR mode on/off",
	 [426] = "F8 view player targets / all targets",
	 [427] = "Plane autopilot override on",
	 [428] = "Plane autopilot override off",
	 [429] = "Plane route autopilot on/off",
	 [430] = "Gear UP",
	 [431] = "Gear DN"
}
