#!/bin/sh

# Remove the current distrib
rm -rf dist/lotatc_client.app

# Generate the app package
python macosx/setup_lotatc_client.py py2app --iconfile macosx/lotatc_client.icns

# Remove unusefull framework files
rm -rf dist/lotatc_client.app/Contents/Frameworks/*.*

# Copying map files
mkdir dist/lotatc_client.app/Contents/Resources/data
cp data/map.svg dist/lotatc_client.app/Contents/Resources/data
cp data/Large.xml dist/lotatc_client.app/Contents/Resources/data
cp data/simple.xml dist/lotatc_client.app/Contents/Resources/data

# Copying lotatc_client files
mkdir dist/lotatc_client.app/Contents/Resources/lotatc_client
cp lotatc_client/*.py dist/lotatc_client.app/Contents/Resources/lotatc_client
cp lotatc_client/*.ui dist/lotatc_client.app/Contents/Resources/lotatc_client
cp -R lotatc_client/resources dist/lotatc_client.app/Contents/Resources/lotatc_client

# Copying lotatc_server files
mkdir dist/lotatc_client.app/Contents/Resources/lotatc_server
cp lotatc_server/*.py dist/lotatc_client.app/Contents/Resources/lotatc_server
cp lotatc_server/*.ui dist/lotatc_client.app/Contents/Resources/lotatc_server
cp -R lotatc_server/res dist/lotatc_client.app/Contents/Resources/lotatc_server

# Copying common files
mkdir dist/lotatc_client.app/Contents/Resources/common
cp common/*.py dist/lotatc_client.app/Contents/Resources/common
cp common/*.ui dist/lotatc_client.app/Contents/Resources/common
cp -R common/resources dist/lotatc_client.app/Contents/Resources/common

# Copying lome files
mkdir dist/lotatc_client.app/Contents/Resources/lome
cp lome/*.py dist/lotatc_client.app/Contents/Resources/lome
cp lome/*.ui dist/lotatc_client.app/Contents/Resources/lome
cp lome/handbook.* dist/lotatc_client.app/Contents/Resources/lome
cp -R lome/dll_api dist/lotatc_client.app/Contents/Resources/lome
cp -R lome/resource dist/lotatc_client.app/Contents/Resources/lome
cp -R lome/utils dist/lotatc_client.app/Contents/Resources/lome

# Copying icons files
cp macosx/lotatc_client.icns dist/lotatc_client.app/Contents/Resources/

# Replacing boot files 
cp macosx/__boot__lotatc_client.py dist/lotatc_client.app/Contents/Resources/__boot__.py

# Copying conf files
cp logging.conf dist/lotatc_client.app/Contents/Resources/
