#!/bin/sh

# Remove the current distrib
rm -rf dist/lome.app

# Generate the app package
python macosx/setup_lome.py py2app --iconfile macosx/lockon.icns

# Remove unusefull framework files
rm -rf dist/lome.app/Contents/Frameworks/*.*

# Copying map files
mkdir dist/lome.app/Contents/Resources/data
cp data/*.* dist/lome.app/Contents/Resources/data

# Copying common files
mkdir dist/lome.app/Contents/Resources/common
cp common/*.py dist/lome.app/Contents/Resources/common
cp common/*.ui dist/lome.app/Contents/Resources/common
cp -R common/resources dist/lome.app/Contents/Resources/common

# Copying lome files
mkdir dist/lome.app/Contents/Resources/lome
cp lome/*.py dist/lome.app/Contents/Resources/lome
cp lome/*.ui dist/lome.app/Contents/Resources/lome
cp lome/handbook.* dist/lome.app/Contents/Resources/lome
cp -R lome/dll_api dist/lome.app/Contents/Resources/lome
cp -R lome/resource dist/lome.app/Contents/Resources/lome
cp -R lome/utils dist/lome.app/Contents/Resources/lome

# Copying icons files
cp macosx/lockon.icns dist/lome.app/Contents/Resources/

# Replacing boot files 
cp macosx/__boot__lome.py dist/lome.app/Contents/Resources/__boot__.py

# Copying conf files
cp logging.conf dist/lome.app/Contents/Resources/
