def _chdir_resource():
    import os
    os.chdir(os.environ['RESOURCEPATH'])
_chdir_resource()


def _disable_linecache():
    import linecache
    def fake_getline(*args, **kwargs):
        return ''
    linecache.orig_getline = linecache.getline
    linecache.getline = fake_getline
_disable_linecache()


def _run(*scripts):
    global __file__
    import os, sys, site
    sys.path = [os.path.join(os.environ['RESOURCEPATH'], 'lib', 'python2.5', 'lib-dynload')] + sys.path
    sys.path = [os.path.join(os.environ['RESOURCEPATH'], 'common')] + sys.path
    sys.path = [os.path.join(os.environ['RESOURCEPATH'], 'lotatc_client')] + sys.path
    sys.path = [os.path.join(os.environ['RESOURCEPATH'], 'lotatc_server')] + sys.path
    sys.path = [os.path.join(os.environ['RESOURCEPATH'], 'lome')] + sys.path
    sys.frozen = 'macosx_app'    
    base = os.environ['RESOURCEPATH']
    site.addsitedir(base)
    site.addsitedir(os.path.join(base, 'Python', 'site-packages'))
    if not scripts:
        import __main__
    for script in scripts:
        path = os.path.join(base, script)
        sys.argv[0] = __file__ = path
        execfile(path, globals(), globals())

_run('lotatc_client.py')
