function LuaExportStart()

	dofile "lua.lua"
	socket = require("socket")


	host = "127.0.0.1"
	port = 10312


	csock = socket.try(socket.connect(host, port)) -- connect to the listener socket
	csock:setoption("tcp-nodelay",true) -- set immediate transmission mode

	local file = io.open("c:/pit_info.log", "w")

	-- Si fichier creer
	if file then
		-- Rediriger les entree/sortie sur le fichier
		io.output(file)
	end
end

function LuaExportBeforeNextFrame()
end

function LuaExportAfterNextFrame()
end

function LuaExportStop()
	csock:close()
end

function LuaExportActivityNextEvent(t)

local tNext = t


	io.write("--------------------------NEXT EVENT-------------------\n")
	local a=LoGetModelTime()
	local b=LoGetMissionStartTime()
	local c=LoGetIndicatedAirSpeed()
	local d=LoGetTrueAirSpeed()
	local e=LoGetAltitudeAboveSeaLevel()
	local f=LoGetAltitudeAboveGroundLevel()
	local g=LoGetAngleOfAttack()
	local h=LoGetAccelerationUnits()
	local i=LoGetVerticalVelocity()
	local j=LoGetADIPitchBankYaw()
	local k=LoGetMagneticYaw()
	local l=LoGetGlideDeviation()
	local m=LoGetSideDeviation()
	local n=LoGetSlipBallPosition()
	local o=LoGetBasicAtmospherePressure()

	local p=LoGetControlPanel_HSI()

	local q=LoGetEngineInfo()

	--[[ 
		for v in (q) do
			io.write(string.format("%s\n",v))
		end
	--]]

	socket.try(csock:send(string.format("%f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f ##\n",a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p.ADF,p.RMI,p.Compass,q.RPM.left,q.RPM.right,q.Temperature.left,q.Temperature.right,q.HydraulicPressure.left,q.HydraulicPressure.right,q.fuel_external,q.fuel_internal)))

	io.write(string.format("%f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f ##\n",a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p.ADF,p.RMI,p.Compass,q.RPM.left,q.RPM.right,q.Temperature.left,q.Temperature.right,q.HydraulicPressure.left,q.HydraulicPressure.right,q.fuel_external,q.fuel_internal))

	
	-- Master Error
	local MasErr= LoGetMCPState()  -- (args - 0, results - 1 (table of key(string).value(boolean))
	local szMasterAlert = ""	
		
	table.foreach(MasErr, function(k,v) if (v) then szMasterAlert=  szMasterAlert.. "1 " else szMasterAlert= szMasterAlert .. "0 " end end)
	
	io.write(string.format("%s\n",szMasterAlert))
	
	socket.try(csock:send(string.format("%s\n",szMasterAlert)))

	--[[
	
	MASTER ALARM ORDER (28 Alarms):

	RightTailPlaneFailure
	EOSFailure
	ECMFailure
	RightAileronFailure
	MasterWarning
	RightEngineFailure
	CannonFailure
	MLWSFailure
	ACSFailure
	RadarFailure
	HelmetFailure
	HUDFailure
	LeftMainPumpFailure
	RightWingPumpFailure
	LeftWingPumpFailure
	MFDFailure
	RWSFailure
	GearFailure
	HydraulicsFailure
	AutopilotFailure
	FuelTankDamage
	LeftAileronFailure
	CanopyOpen
	RightMainPumpFailure
	StallSignalization
	LeftEngineFailure
	AutopilotOn
	LeftTailPlaneFailure

	--]]

	-- ================== Get INFO ON TWS ==============================
	local lo=LoGetTWSInfo()
	
	-- add TWS Mode
	io.write(string.format("Mode :%d\n",lo.Mode))
	socket.try(csock:send(string.format("Mode :%d\n",lo.Mode)))
	
	-- Values for each emitter
	for w,y in (lo.Emitters) do	

		 io.write(string.format("%s %s %s %s %s %f %f %s##\n",w,y.Type.level1,y.Type.level2,y.Type.level3,y.Type.level4,y.Power,y.Azimuth,y.SignalType))
		 socket.try(csock:send(string.format("%s %s %s %s %s %f %f %s##\n",w,y.Type.level1,y.Type.level2,y.Type.level3,y.Type.level4,y.Power,y.Azimuth,y.SignalType)))
	end

	-- Mark end of TWS Block
	io.write("End\n")
	socket.try(csock:send(string.format("End")))
	

	tNext = tNext + 1.0

	return tNext
end
