
--*************ARMEMENT 
gLastGunStatus = "SAFE"
gLastWeaponType = 0
--************FIN ARMEMENT***


function ProcessIndicators(pIndicatorTables)

    local lIndicatorTable, lDevice_Arg ,lSIOC_Var, lArgumentValue, lPanel, lPanelId

    local lSIOC_SendString = ""

    for i , lIndicatorTable in pairs(pIndicatorTables) 

    do     

        for lSIOC_Var ,lDevice_Arg in pairs(lIndicatorTable) 

        do 

            -- Check if the panelID changes between indicators 

            if lPanelId ~= lDevice_Arg[1] then 

                lPanelId = lDevice_Arg[1]

                -- Get the device

                lPanel = GetDevice(lDevice_Arg[1])

                --Check to see that the device is valid otherwise we return an emty string

                if type(lPanel) ~= "table" then

                    return ""

                end

                -- Update the panel

                lPanel:update_arguments()

            end

             

            lArgumentValue = lPanel:get_argument_value(lDevice_Arg[2])

            -- For some reason the get_argument_value function call above returns 0.1000001256, 0.20000012313 

            -- or similar so we need round this value to 0.1, 0.2 etc

            lArgumentValue = round(lArgumentValue, 1)

    

            -- 0 or 0.2 means that the indicator should be off => the SIOC param should be 0

            -- For any other value the indicator should be on => the SIOC param should be 1

            if ((lArgumentValue == 0) or (lArgumentValue == 0.2)) then

                lSIOC_SendString = lSIOC_SendString..lSIOC_Var.."=0:"

            else

                lSIOC_SendString = lSIOC_SendString..lSIOC_Var.."=1:"

            end            

        end

    end

    return lSIOC_SendString

end
--***********************ARMEMENT ****************************

function AmmoCountersAndType(pRemainSIOCParam, pRNDSSIOCParam, pTypeSIOCParam)
    local lSIOC_SendString =""
    -- Get the device 
    local lWeaponSystem = GetDevice(12)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lWeaponSystem) ~= "table" then
        return ""
    end
    
    local lMainPanel = GetDevice(0)
    lMainPanel:update_arguments()
    
    local lGunSelected = lMainPanel:get_argument_value(615)
    local lTargetingSystemOn = lMainPanel:get_argument_value(433)  
   
    if lTargetingSystemOn == 1 then
      
      -- Somewhat ugly code due to most simmer not having the BS special gun/missile
        -- lockout system on their sticks.
        if lGunSelected == 0 then
            gLastGunStatus = "ARMED"    
        elseif lGunSelected == -1 then
            gLastGunStatus = "SAFE"
        end     

    
        -- Get and correctly round the ammo count. Ex Ammocount = 236 / 10 = 23.6. String match to "(%d+)" => 23
        local lCannonAmmoCount = string.match(lWeaponSystem:get_selected_gun_ammo_count() / 10, "(%d+)")
    
        -- Add the cannon ammo count to the SIOC string
        lSIOC_SendString = pRNDSSIOCParam.."="..lCannonAmmoCount..":"
    
        -- Get and calculate the ammo for rockets ATGM etc 
        local lArrayOfStationNumbers  = lWeaponSystem:get_selected_weapon_stations()	    
        local lSelectedStationsAmmoCount = 0
        for i=1,#lArrayOfStationNumbers do
            lSelectedStationsAmmoCount =
            lSelectedStationsAmmoCount + lWeaponSystem:get_weapon_count_on_station(lArrayOfStationNumbers[i])  
        end
    

        -- -999999 tells SIOC to turn of the display
        if (#lArrayOfStationNumbers ~= 0 and gLastGunStatus == "SAFE") then
            local lWeaponType   = lWeaponSystem:get_weapon_type_on_station(lArrayOfStationNumbers[1])
          

            
            lSIOC_SendString = lSIOC_SendString..pRemainSIOCParam.."="..lSelectedStationsAmmoCount..":"
        

            local lWeaponIndicator
            if lWeaponType == "EMPTY" then 
                lWeaponIndicator = gLastWeaponType 
            else
                lWeaponIndicator = weaponsTypeIndicator[lWeaponType] or 0 
            end
          

        
            if lWeaponIndicator > 0  then
                lSIOC_SendString = lSIOC_SendString..pTypeSIOCParam.."="..lWeaponIndicator..":"
                gLastWeaponType = lWeaponIndicator
            end
            
        else
            lSIOC_SendString = lSIOC_SendString..pRemainSIOCParam.."=-999999:"..pTypeSIOCParam.."=0"..":"
        end
    
    else
        lSIOC_SendString = lSIOC_SendString..pRemainSIOCParam.."=-999999:"..pTypeSIOCParam.."=0:"..pRNDSSIOCParam.."=-999999:"
    end
  
    return lSIOC_SendString
end


--************************FIN ARMEMENT 

------------------------------------AGR_81_Roll--------------------------------------------------
function AGR_81_Roll(pAGR_81_RollSIOCParam)
    -- Get the device 
    local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lMainPanel) ~= "table" then
        return ""
    end
    lMainPanel:update_arguments()
    
    local lAGR_81_R = lMainPanel:get_argument_value(214)* 1000  -- vy.arg_number=24 (s. mainpanel_init.lua) (WB)28--214
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
    local lSIOC_SendString = pAGR_81_RollSIOCParam.."="..round(lAGR_81_R)..":"
         
    return lSIOC_SendString
end


------------------------------------AGR_81_Pitch--------------------------------------------------

function AGR_81_Pitch(pAGR_81_PitchSIOCParam)
    -- Get the device 
    local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lMainPanel) ~= "table" then
        return ""
    end
    lMainPanel:update_arguments()
    
    local lAGR_81_P = lMainPanel:get_argument_value(213)* 1000  -- vy.arg_number=24 (s. mainpanel_init.lua) (WB)27 --213
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
    local lSIOC_SendString = pAGR_81_PitchSIOCParam.."="..round(lAGR_81_P)..":"
         
    return lSIOC_SendString
end
------------------------------------AGR_81_failure-------------------------------------------------

--function AGR_81_failure_flag(pAGR_81_failure_flagSIOCParam)
    -- Get the device 
 --   local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
  --  if type(lMainPanel) ~= "table" then
   --     return ""
  -- end
  --  lMainPanel:update_arguments()
    
  --  local lAGR_81_failur = lMainPanel:get_argument_value(19)  -- vy.arg_number=24 (s. mainpanel_init.lua) (WB)
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
  --  local lSIOC_SendString = pAGR_81_failure_flagSIOCParam.."="..round(lAGR_81_failur)..":"
         
  --  return lSIOC_SendString
--end

---------------------------------ADF_right01---165-----------------------------

function ADF_right01(pADF_right01SIOCParam)  ---ADF_right01

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_right01 = lMainPanel:get_argument_value(165) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_right01SIOCParam.."="..round(lADF_right01)..":"

         

    return lSIOC_SendString

end



---------------------------------ADF_rightun---164-----------------------------

function ADF_rightun(pADF_rightunSIOCParam)  ---ADF_rightdix

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_rightun = lMainPanel:get_argument_value(164) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_rightunSIOCParam.."="..round(lADF_rightun)..":"

         

    return lSIOC_SendString

end


---------------------------------ADF_rightdix---163-----------------------------

function ADF_rightdix(pADF_rightdixSIOCParam)  ---ADF_rightdix

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_rightdix = lMainPanel:get_argument_value(163) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_rightdixSIOCParam.."="..round(lADF_rightdix)..":"

         

    return lSIOC_SendString

end


---------------------------------ADF_rightcent---162-----------------------------

function ADF_rightcent(pADF_rightcentSIOCParam)  ---ADF_rightcent

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_rightcent = lMainPanel:get_argument_value(162) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_rightcentSIOCParam.."="..round(lADF_rightcent)..":"

         

    return lSIOC_SendString

end

-------------------------------------ADF_leftun 160--------------------------------------

function ADF_leftun(pADF_leftunSIOCParam)  ---ADF_leftun

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_leftun = lMainPanel:get_argument_value(160) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_leftunSIOCParam.."="..round(lADF_leftun)..":"

         

    return lSIOC_SendString

end

----------------------------------ADF_left01----161---------------------------------

function ADF_left01(pADF_left01SIOCParam)  --ADF_left01

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_left01 = lMainPanel:get_argument_value(161) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_left01SIOCParam.."="..round(lADF_left01)..":"

         

    return lSIOC_SendString

end


-------------------------------------ADF_leftdix= 159--------------------------------------

function ADF_leftdix(pADF_leftdixSIOCParam)  ---ADF_leftdix

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_leftdix = lMainPanel:get_argument_value(159) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_leftdixSIOCParam.."="..round(lADF_leftdix)..":"

         

    return lSIOC_SendString

end


---------------------------------------ADF_leftcent=158--------------------------------------

function ADF_leftcent(pADF_leftcentSIOCParam)  ---ADF_leftcent=158

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lADF_leftcent = lMainPanel:get_argument_value(158) * 10--

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pADF_leftcentSIOCParam.."="..round(lADF_leftcent)..":"

         

    return lSIOC_SendString

end




---------------------------------------AM_Radio_freq_dixieme = 138-------------------------------------------

function RAD_AM_01(pRAD_AM_01SIOCParam)  ---RAD_AM_01SIOCParam

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lRAD_AM_01 = lMainPanel:get_argument_value(138) * 10  --138

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pRAD_AM_01SIOCParam.."="..round(lRAD_AM_01)..":"

         

    return lSIOC_SendString

end


---------------------------------------AM_Radio_freq_cent = 133-------------------------------------------

function RAD_AM100(pRAD_AM100SIOCParam)  ---controllers PAD

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lRAD_AM100 = lMainPanel:get_argument_value(133) * 10  --133

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pRAD_AM100SIOCParam.."="..round(lRAD_AM100)..":"

         

    return lSIOC_SendString

end

---------------------------------------AM_Radio_freq_CENTIEME = 139-------------------------------------------

function RAD_AM_001(pRAD_AM_001SIOCParam)  ---RAD_AM_001

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lRAD_AM_001 = lMainPanel:get_argument_value(139) * 100 --139

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pRAD_AM_001SIOCParam.."="..round(lRAD_AM_001)..":"

         

    return lSIOC_SendString

end


--------------------------------------AM_Radio_freq_dix = 134,----------------------------------------

function RAD_AM10(pRAD_AM10SIOCParam)  ---controllers PAG

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lRAD_AM10 = lMainPanel:get_argument_value(134) * 10-- 134

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pRAD_AM10SIOCParam.."="..round(lRAD_AM10)..":"

         

    return lSIOC_SendString

end





------------------------------------	AM_Radio_freq_unite = 136------------------------------------------

function RAD_AM1(pRAD_AM1SIOCParam)  ---controllers PAG

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lRAD_AM1 = lMainPanel:get_argument_value(136) * 10 -- 136

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pRAD_AM1SIOCParam.."="..round(lRAD_AM1)..":"

         

    return lSIOC_SendString

end

--------------------------------- AFFICHEUR MUNI CANON -------------------------------------------------
function MUNI_CANON(pCANON_siocPARAM)
    -- Get the device 
    local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lMainPanel) ~= "table" then
        return ""
    end
    lMainPanel:update_arguments()
    
    local lCANON = lMainPanel:get_argument_value(356)* 100000  -- 
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
    local lSIOC_SendString = pCANON_siocPARAM.."="..round(lCANON)..":"
         
    return lSIOC_SendString
end





--------------------------------------Temperature T4= 15------------------------------------------

function T4(pT4SIOCParam)  ---controllersT4temperature

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lTT4 = lMainPanel:get_argument_value(15) * 1000

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = pT4SIOCParam.."="..round(lTT4)..":"

         

    return lSIOC_SendString

end



--------------------------------------PA_aiguille_lacet = 37------------------------------------------

function lacet(placetSIOCParam)  ---controllersT4temperature

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    

	-- (s. mainpanel_init.lua) (WB)

	-- 0-900°c: DCS: 0-1 equivalent to Servo 0..1023 -> 200..1023  (0-200 dead zone)

    --local lAPUtemp = (lMainPanel:get_argument_value(6) * 823) + 200

	local lTlacet = lMainPanel:get_argument_value(39) * -1000

    --logfile:write(round(lAPUtemp))

    --logfile:write("\n")    

        

    --local lSIOC_SendString = pAPUTempSIOCParam.."="..round(Servo(lAPUtemp, APUtempServoCalTable))..":"

	local lSIOC_SendString = placetSIOCParam.."="..round(lTlacet)..":"

         

    return lSIOC_SendString

end

--******************************************************PA_aiguille_Roulis = 38***********************************************************

function roulis(proulisSIOCParam)  ---roulis

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    


	local lroulis = lMainPanel:get_argument_value(38) * 1000


        


	local lSIOC_SendString = proulisSIOCParam.."="..round(lroulis)..":"

         

    return lSIOC_SendString

end
--******************************************************************************************************************************************

--*************************************************PA_aiguille_tangage = 39************************************************************

function tangage(ptangageSIOCParam)  ---tangage

    -- Get the device 

    local lMainPanel = GetDevice(0)

    --Check to see that the device is valid otherwise we return an emty string 

    if type(lMainPanel) ~= "table" then

        return ""

    end

    lMainPanel:update_arguments()

    


	local ltangage = lMainPanel:get_argument_value(37) * -1000


        


	local lSIOC_SendString = ptangageSIOCParam.."="..round(ltangage)..":"

         

    return lSIOC_SendString

end




-- Generate the SIOC string to reset (turn off) all indicator lamsp

function ResetIndicators(pIndicatorTables)

    local lIndicatorTable, lDevice_Arg ,lSIOC_Var 

    local lSIOC_SendString = ""

    

    for i , lIndicatorTable in pairs(pIndicatorTables) 

    do     

        for lSIOC_Var ,lDevice_Arg in pairs(lIndicatorTable) 

        do 

            lSIOC_SendString = lSIOC_SendString..lSIOC_Var.."=0:"

        end            

    end

    return lSIOC_SendString

end



--------------------------------------------------------------------------------------

-- Generate SIOC string to reset (turn off) Servos

function ResetSIOCvar(pSiocVar)

    local lSIOC_SendString = ""

    

    lSIOC_SendString = lSIOC_SendString..pSiocVar.."=0:"

    

    return lSIOC_SendString

end


-- Simple round function

function round(num, idp)

  local mult = 10^(idp or 0)

  return math.floor(num * mult + 0.5) / mult

end



-- Used togheter with a for loop to extract Sioc parameters and their value from a string

function SIOC_Parse(pSIOC_String)

    local i = -1

    return function ()

        i= string.find(pSIOC_String, ":",i+1)

        if i ~= nil then

            return tonumber(string.match(pSIOC_String, ":(%d+)=%d+",i)) , tonumber(string.match(pSIOC_String, ":%d+=(%d+)",i)) 

        end

    end

end
-- Device/switch specific functions twopositions 

function TwoPositionSwitch2(pValue, pDevice, pNumber, pOnValue, pInvert)

    if pInvert then

        if pValue == 1 then

           pValue = 0

        else

           pValue = 2

        end

    end

 

    GetDevice(pDevice):performClickableAction(pNumber + 3000, pValue * pOnValue)

end


-- Device/switch specific functions

function TwoPositionSwitch(pValue, pDevice, pNumber, pOnValue, pInvert)

    if pInvert then

        if pValue == 1 then

           pValue = 0

        else

           pValue = 1

        end

    end

 

    GetDevice(pDevice):performClickableAction(pNumber + 3000, pValue * pOnValue)

end

--For a rotary/rotary switch, sends (pValue - 1/10) to pDevice (ex 12 for WEAP-Interface)

-- Set your SIOC parameter to 1 for position 1, 2 for position 2.....etc. 
 function SimpleRotary4(pValue, pDevice, pNumber)

    GetDevice(pDevice):performClickableAction(pNumber + 3000,pValue - 1)

end

function SimpleRotary3(pValue, pDevice, pNumber)

    GetDevice(pDevice):performClickableAction(pNumber + 3000, (pValue -1)/20)

end

function SimpleRotary2(pValue, pDevice, pNumber)

    GetDevice(pDevice):performClickableAction(pNumber + 3000, pValue * pOnValue)

end

function SimpleRotary(pValue, pDevice, pNumber)

    GetDevice(pDevice):performClickableAction(pNumber + 3000,(pValue - 1)/10)

end

function SimpleRotaryTest(pValue, pDevice, pNumber)

    GetDevice(pDevice):performClickableAction(pNumber + 3000,pValue - 2)

end
---  RADIO FM 
function Radio_R863_Frequency(pRadio_R863FsiocPARAM)
    -- Get the device R863 (38)
    local R863 = GetDevice(28)
    --Check to see that the device is valid otherwise we return an emty string 
    --if type(R863) ~= "table" then
    --    return ""
    --end
    --R863:update_arguments()

    local F863 = (math.floor(R863:get_frequency() / 25000)) * 25
              
    local lSIOC_SendString = pRadio_R863FsiocPARAM.."="..F863..":"
         
    return lSIOC_SendString
end
--- RADIO UHF 

function Radio_R86_Frequency(pRadio_R86FsiocPARAM)
    -- Get the device R863 (38)
    local R86 = GetDevice(31)
    --Check to see that the device is valid otherwise we return an emty string 
    --if type(R863) ~= "table" then
    --    return ""
    --end
    --R863:update_arguments()

    local F86 = (math.floor(R86:get_frequency() / 25000)) * 25
              
    local lSIOC_SendString = pRadio_R86FsiocPARAM.."="..F86..":"
         
    return lSIOC_SendString
end
------------------------------------CAP MAGNETIQUE--------------------------------------------------

function Heading(pHeadingSIOCParam)
    -- Get the device 
    local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lMainPanel) ~= "table" then
        return ""
    end
    lMainPanel:update_arguments()
    
    local lHeading= lMainPanel:get_argument_value(26)* 1000  -- vy.arg_number=24 (s. mainpanel_init.lua) (WB)27
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
    local lSIOC_SendString = pHeadingSIOCParam.."="..round(lHeading)..":"
         
    return lSIOC_SendString
end
------------------------------------TEMP EXTER-------25---------Qcomb 137--------------------------------

function TempExt(pTempExtSIOCParam)
    -- Get the device 
    local lMainPanel = GetDevice(0)
    --Check to see that the device is valid otherwise we return an emty string 
    if type(lMainPanel) ~= "table" then
        return ""
    end
    lMainPanel:update_arguments()
    
    local lTempExt= lMainPanel:get_argument_value(25)* 1000  -- vy.arg_number=24 (s. mainpanel_init.lua) (WB)27
    --logfile:write(lVariometer)
    --logfile:write("\n")    
        
    local lSIOC_SendString = pTempExtSIOCParam.."="..round(lTempExt)..":"
         
    return lSIOC_SendString
end
